/*
 * Decompiled with CFR 0.152.
 */
package com.dls.jpos.transport;

import com.dls.jpos.common.DLSDeviceInfo;
import com.dls.jpos.common.DLSJposConst;
import com.dls.jpos.transport.DLSPort;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DLSUsbWin32
extends DLSPort {
    private int nAttachment = 0;
    private String logData = null;
    private String sResult = null;
    private boolean bLoaded = false;
    private volatile boolean bLiveWeightIsRunning = false;
    private final ScheduledExecutorService m_scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> m_liveWeight = null;
    private static final Logger m_log = LogManager.getLogger(DLSUsbWin32.class);

    private synchronized native String nativeQueryDevice(int var1, int var2, int var3) throws Exception;

    private synchronized native boolean nativeOpenPort(String var1) throws Exception;

    private synchronized native boolean nativeClosePort() throws Exception;

    private synchronized native boolean nativeSendData(byte[] var1, int var2) throws Exception;

    private synchronized native boolean nativeStartLiveWeight(byte[] var1, int var2, int var3) throws Exception;

    private synchronized native boolean nativeStopLiveWeight() throws Exception;

    public DLSUsbWin32(DLSDeviceInfo info) {
        super(info);
        this.loadLibrary();
    }

    private void loadLibrary() {
        m_log.trace("loadLibrary (in)");
        try {
            String lib_path = System.getProperty("java.library.path");
            m_log.debug("java.library.path: " + lib_path);
            if (System.getProperty("os.arch").contains("x86")) {
                m_log.debug("Attempt to load Win32Hid.dll");
                System.loadLibrary("Win32Hid");
            } else {
                m_log.debug("Attempt to load Win64Hid.dll");
                System.loadLibrary("Win64Hid");
            }
            this.bLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            m_log.error("error: unable to load WinHid.dll from current library path, create new lib path. ", (Throwable)e);
        }
        m_log.trace("loadLibrary (out)");
    }

    @Override
    public boolean openPort() {
        m_log.trace("openPort (in)");
        if (!this.bLoaded) {
            m_log.error("Win32Hid library not loaded....SEVERE error....");
            return false;
        }
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        boolean bRc = true;
        int iUsage = oInfo.getUsage();
        m_log.debug(Integer.toHexString(iUsage) + " openPort");
        String strPath = "";
        try {
            strPath = this.nativeQueryDevice(oInfo.getVendorId(), oInfo.getProductId(), iUsage);
            this.nativeOpenPort(strPath);
            m_log.debug("Opened usb port: " + strPath);
            this.bOpen = true;
        }
        catch (Exception e) {
            m_log.error("openPort: Exception. ", (Throwable)e);
            bRc = false;
        }
        catch (UnsatisfiedLinkError e) {
            m_log.error("openPort: Unsatisfied Link. ", (Throwable)e);
            bRc = false;
        }
        m_log.trace("openPort (out): " + Boolean.toString(bRc));
        return bRc;
    }

    public String queryPath(DLSDeviceInfo oInfo) throws Exception {
        String sPath = "";
        sPath = this.nativeQueryDevice(oInfo.getVendorId(), oInfo.getProductId(), oInfo.getUsage());
        return sPath;
    }

    @Override
    public boolean closePort() {
        boolean result = true;
        m_log.trace("closePort (in)");
        if (!this.bLoaded) {
            m_log.error("Win32Hid library not loaded....SEVERE error....");
            result = false;
            return result;
        }
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        int iUsage = oInfo.getUsage();
        m_log.debug(Integer.toHexString(iUsage) + " closePort");
        try {
            result = this.nativeClosePort();
        }
        catch (Exception e) {
            m_log.error("closePort: Exception. ", (Throwable)e);
            result = false;
        }
        catch (UnsatisfiedLinkError e) {
            m_log.error("closePort: Unsatisfied Link. ", (Throwable)e);
            result = false;
        }
        this.bOpen = false;
        m_log.trace("closePort (out): " + Boolean.toString(result));
        return result;
    }

    @Override
    public void changeBaudRate(int nBaud) {
    }

    @Override
    public boolean startLiveWeight(byte[] buf, int len, int rate) {
        m_log.trace("startLiveWeight (in): " + new String(buf) + ", " + Integer.toString(len) + ", " + Integer.toString(rate));
        final byte[] cmd = (byte[])buf.clone();
        Runnable lwThread = new Runnable(){

            @Override
            public void run() {
                DLSUsbWin32.this.sendData(cmd, cmd.length);
            }
        };
        this.m_liveWeight = this.m_scheduler.scheduleAtFixedRate(lwThread, rate, rate, TimeUnit.MILLISECONDS);
        this.bLiveWeightIsRunning = true;
        m_log.trace("startLiveWeight (out): true");
        return true;
    }

    @Override
    public void stopLiveWeight() {
        m_log.trace("stopLiveWeight (in)");
        if (!this.bLiveWeightIsRunning) {
            return;
        }
        this.m_liveWeight.cancel(true);
        this.bLiveWeightIsRunning = false;
        m_log.trace("stopLiveWeight (out)");
    }

    @Override
    public int sendData(byte[] buf, int len) {
        StringBuilder oSb = new StringBuilder();
        m_log.trace("sendData (in): " + new String(buf) + ", " + Integer.toString(len));
        if (!this.bLoaded) {
            m_log.error("Windows HID library not loaded....SEVERE error....");
            return 0;
        }
        m_log.debug("sendData: inBuf length: " + buf.length + " len: " + len);
        for (int i = 0; i < len; ++i) {
            oSb.append(String.format(" 0x%02X", buf[i]));
        }
        m_log.debug("sendData: #bytes to send[" + len + "]" + oSb.toString());
        try {
            this.nativeSendData(buf, len);
        }
        catch (Exception e) {
            m_log.error("sendData: Exception. ", (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            m_log.error("sendData: Unsatisfied Link. ", (Throwable)e);
        }
        m_log.trace("sendData (out): 1");
        return 1;
    }

    public void onDeviceRemoved() {
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.debug(Integer.toHexString(oInfo.getUsage()) + " Device Removed: " + Integer.toHexString(oInfo.getVendorId()) + "," + Integer.toHexString(oInfo.getProductId()));
        this.fireDeviceRemovedEvent();
    }

    public void onDeviceReattached() {
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.debug(Integer.toHexString(oInfo.getUsage()) + " Device Reattached: " + Integer.toHexString(oInfo.getVendorId()) + "," + Integer.toHexString(oInfo.getProductId()));
        this.fireDeviceReattachedEvent();
    }

    public void onDataReceived(byte[] inBuf, int len) {
        this.fireDataReceivedEvent(inBuf, len);
    }

    public void logLog(String strMsg) {
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.debug(Integer.toHexString(oInfo.getUsage()) + " C++: " + strMsg);
    }

    public void logError(String strMsg) {
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.error(Integer.toHexString(oInfo.getUsage()) + " C++: " + strMsg);
    }

    public void logIn(String strMsg) {
        if (strMsg == null) {
            m_log.error("logIn: Invalid log message (null).");
            return;
        }
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.trace(Integer.toHexString(oInfo.getUsage()) + " C++ (in): " + strMsg);
    }

    public void logOut(String strMsg) {
        DLSDeviceInfo oInfo = this.getDeviceInfo();
        m_log.trace(Integer.toHexString(oInfo.getUsage()) + " C++ (out): " + strMsg);
    }

    public boolean FWBusy() {
        return DLSJposConst.updateInProgress;
    }
}

