/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSKeyboardControl114;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import jpos.services.POSKeyboardService110;
import jpos.services.POSKeyboardService111;
import jpos.services.POSKeyboardService112;
import jpos.services.POSKeyboardService113;
import jpos.services.POSKeyboardService114;
import jpos.services.POSKeyboardService12;
import jpos.services.POSKeyboardService13;
import jpos.services.POSKeyboardService14;
import jpos.services.POSKeyboardService15;
import jpos.services.POSKeyboardService16;
import jpos.services.POSKeyboardService17;
import jpos.services.POSKeyboardService18;
import jpos.services.POSKeyboardService19;

public class POSKeyboard
extends BaseJposControl
implements POSKeyboardControl114,
JposConst {
    protected POSKeyboardService12 service12;
    protected POSKeyboardService13 service13;
    protected POSKeyboardService14 service14;
    protected POSKeyboardService15 service15;
    protected POSKeyboardService16 service16;
    protected POSKeyboardService17 service17;
    protected POSKeyboardService18 service18;
    protected POSKeyboardService19 service19;
    protected POSKeyboardService110 service110;
    protected POSKeyboardService111 service111;
    protected POSKeyboardService112 service112;
    protected POSKeyboardService113 service113;
    protected POSKeyboardService114 service114;
    protected Vector dataListeners;
    protected Vector directIOListeners;
    protected Vector errorListeners;
    protected Vector statusUpdateListeners;

    public POSKeyboard() {
        this.deviceControlDescription = "JavaPOS POSKeyboard Device Control";
        this.deviceControlVersion = 1014000;
        this.dataListeners = new Vector();
        this.directIOListeners = new Vector();
        this.errorListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    @Override
    public boolean getCapKeyUp() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapKeyUp();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getCapPowerReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCompareFirmwareVersion();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUpdateFirmware();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public boolean getAutoDisable() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getAutoDisable();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public void setAutoDisable(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setAutoDisable(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public int getDataCount() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDataCount();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public boolean getDataEventEnabled() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDataEventEnabled();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public void setDataEventEnabled(boolean bl) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setDataEventEnabled(bl);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public int getEventTypes() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getEventTypes();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public void setEventTypes(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setEventTypes(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public int getPOSKeyData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getPOSKeyData();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public int getPOSKeyEventType() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getPOSKeyEventType();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerNotify();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public void setPowerNotify(int n) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            this.service13.setPowerNotify(n);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerState();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public void clearInput() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.clearInput();
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public void resetStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public void retrieveStatistics(String[] stringArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(stringArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public void updateStatistics(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public void compareFirmwareVersion(String string, int[] nArray) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.compareFirmwareVersion(string, nArray);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    public void updateFirmware(String string) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.updateFirmware(string);
        }
        catch (JposException jposException) {
            throw jposException;
        }
        catch (Exception exception) {
            throw new JposException(111, "Unhandled exception from Device Service", exception);
        }
    }

    @Override
    protected EventCallbacks createEventCallbacks() {
        return new POSKeyboardCallbacks();
    }

    @Override
    protected void setDeviceService(BaseService baseService, int n) throws JposException {
        if (baseService == null) {
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            this.service16 = null;
            this.service17 = null;
            this.service18 = null;
            this.service19 = null;
            this.service110 = null;
            this.service111 = null;
            this.service112 = null;
            this.service113 = null;
            this.service114 = null;
        } else {
            if (this.serviceVersion >= 1002000) {
                try {
                    this.service12 = (POSKeyboardService12)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService12 interface", exception);
                }
            }
            if (this.serviceVersion >= 1003000) {
                try {
                    this.service13 = (POSKeyboardService13)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService13 interface", exception);
                }
            }
            if (this.serviceVersion >= 1004000) {
                try {
                    this.service14 = (POSKeyboardService14)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService14 interface", exception);
                }
            }
            if (this.serviceVersion >= 1005000) {
                try {
                    this.service15 = (POSKeyboardService15)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService15 interface", exception);
                }
            }
            if (this.serviceVersion >= 1006000) {
                try {
                    this.service16 = (POSKeyboardService16)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService16 interface", exception);
                }
            }
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (POSKeyboardService17)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService17 interface", exception);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (POSKeyboardService18)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService18 interface", exception);
                }
            }
            if (this.serviceVersion >= 1009000) {
                try {
                    this.service19 = (POSKeyboardService19)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService19 interface", exception);
                }
            }
            if (this.serviceVersion >= 1010000) {
                try {
                    this.service110 = (POSKeyboardService110)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService110 interface", exception);
                }
            }
            if (this.serviceVersion >= 1011000) {
                try {
                    this.service111 = (POSKeyboardService111)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService111 interface", exception);
                }
            }
            if (this.serviceVersion >= 1012000) {
                try {
                    this.service112 = (POSKeyboardService112)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService112 interface", exception);
                }
            }
            if (this.serviceVersion >= 1013000) {
                try {
                    this.service113 = (POSKeyboardService113)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService113 interface", exception);
                }
            }
            if (this.serviceVersion >= 1014000) {
                try {
                    this.service114 = (POSKeyboardService114)baseService;
                }
                catch (Exception exception) {
                    throw new JposException(104, "Service does not fully implement POSKeyboardService114 interface", exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataListener(DataListener dataListener) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.addElement(dataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataListener(DataListener dataListener) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.removeElement(dataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(directIOListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDirectIOListener(DirectIOListener directIOListener) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(directIOListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addErrorListener(ErrorListener errorListener) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(errorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeErrorListener(ErrorListener errorListener) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(errorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(statusUpdateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatusUpdateListener(StatusUpdateListener statusUpdateListener) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(statusUpdateListener);
        }
    }

    protected class POSKeyboardCallbacks
    implements EventCallbacks {
        protected POSKeyboardCallbacks() {
        }

        @Override
        public BaseControl getEventSource() {
            return POSKeyboard.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireDataEvent(DataEvent dataEvent) {
            Vector vector = POSKeyboard.this.dataListeners;
            synchronized (vector) {
                for (int i = 0; i < POSKeyboard.this.dataListeners.size(); ++i) {
                    ((DataListener)POSKeyboard.this.dataListeners.elementAt(i)).dataOccurred(dataEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireDirectIOEvent(DirectIOEvent directIOEvent) {
            Vector vector = POSKeyboard.this.directIOListeners;
            synchronized (vector) {
                for (int i = 0; i < POSKeyboard.this.directIOListeners.size(); ++i) {
                    ((DirectIOListener)POSKeyboard.this.directIOListeners.elementAt(i)).directIOOccurred(directIOEvent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireErrorEvent(ErrorEvent errorEvent) {
            Vector vector = POSKeyboard.this.errorListeners;
            synchronized (vector) {
                for (int i = 0; i < POSKeyboard.this.errorListeners.size(); ++i) {
                    ((ErrorListener)POSKeyboard.this.errorListeners.elementAt(i)).errorOccurred(errorEvent);
                }
            }
        }

        @Override
        public void fireOutputCompleteEvent(OutputCompleteEvent outputCompleteEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireStatusUpdateEvent(StatusUpdateEvent statusUpdateEvent) {
            Vector vector = POSKeyboard.this.statusUpdateListeners;
            synchronized (vector) {
                for (int i = 0; i < POSKeyboard.this.statusUpdateListeners.size(); ++i) {
                    ((StatusUpdateListener)POSKeyboard.this.statusUpdateListeners.elementAt(i)).statusUpdateOccurred(statusUpdateEvent);
                }
            }
        }
    }
}

